/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.HLE.modules.sceNetInet;
import jpcsp.HLE.modules.sceWlan;
import jpcsp.hardware.Wlan;
import jpcsp.network.BaseWlanAdapter;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.util.Utilities;

public class JpcspWlanAdapter
extends BaseWlanAdapter {
    public static final byte WLAN_CMD_DATA = 0;
    public static final byte WLAN_CMD_SCAN_REQUEST = 1;
    public static final byte WLAN_CMD_SCAN_RESPONSE = 2;
    private static int wlanSocketPort = 30010;
    private DatagramSocket wlanSocket;

    private boolean createWlanSocket() {
        if (this.wlanSocket == null) {
            boolean retry;
            do {
                retry = false;
                try {
                    InetAddress localInetAddress = Wlan.getLocalInetAddress();
                    this.wlanSocket = new DatagramSocket(wlanSocketPort, Wlan.getLocalInetAddress());
                    this.wlanSocket.setBroadcast(true);
                    this.wlanSocket.setSoTimeout(1);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("createWlanSocket successful on port %d, localInetAddress %s", wlanSocketPort, localInetAddress));
                }
                catch (BindException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("createWlanSocket port %d already in use (%s) - retrying with port %d", wlanSocketPort, e, wlanSocketPort + 1));
                    }
                    ++wlanSocketPort;
                    retry = true;
                }
                catch (SocketException e) {
                    log.error((Object)"createWlanSocket", (Throwable)e);
                }
            } while (retry);
        }
        return this.wlanSocket != null;
    }

    @Override
    public void start() throws IOException {
        if (!this.createWlanSocket()) {
            throw new IOException("Cannot create JpcspWlanAdapter socket");
        }
    }

    public static int getSocketPort() {
        return wlanSocketPort;
    }

    private int getBroadcastPort(int channel) {
        if (channel >= 0 && Modules.sceWlanModule.getChannelMode(channel) == 1) {
            return Modules.sceWlanModule.getAccessPoint().getPort();
        }
        if (Wlan.hasLocalInetAddress()) {
            return wlanSocketPort;
        }
        return wlanSocketPort ^ 1;
    }

    private void sendPacket(byte[] buffer, int offset, int length) throws IOException {
        InetSocketAddress[] broadcastAddress;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendPacket %s", Utilities.getMemoryDump(buffer, offset, length)));
        }
        if ((broadcastAddress = sceNetInet.getBroadcastInetSocketAddress(this.getBroadcastPort(Modules.sceWlanModule.getJoinedChannel()))) != null) {
            for (int i = 0; i < broadcastAddress.length; ++i) {
                DatagramPacket packet = new DatagramPacket(buffer, offset, length, broadcastAddress[i]);
                try {
                    this.wlanSocket.send(packet);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)String.format("sendPacket successful on %s", broadcastAddress[i]));
                    continue;
                }
                catch (SocketException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("sendPacket on %s", broadcastAddress[i]), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendWlanPacket(byte[] buffer, int offset, int length) throws IOException {
        if (!this.createWlanSocket()) {
            return;
        }
        byte[] packetBuffer = new byte[length + 1 + 32];
        int packetOffset = 0;
        packetBuffer[packetOffset] = 0;
        Utilities.writeStringNZ(packetBuffer, ++packetOffset, 32, Modules.sceWlanModule.getJoinedChannelSSID());
        System.arraycopy(buffer, offset, packetBuffer, packetOffset += 32, length);
        this.sendPacket(packetBuffer, 0, packetOffset += length);
    }

    private void processCmd(byte cmd, byte[] buffer, int offset, int length) throws IOException {
        byte[] packetMacAddress = new byte[6];
        System.arraycopy(buffer, offset, packetMacAddress, 0, 6);
        offset += 6;
        length -= 6;
        if (sceNetAdhoc.isMyMacAddress(packetMacAddress)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Ignoring packet coming from myself", new Object[0]));
            }
            return;
        }
        if (cmd == 1) {
            byte[] scanResponse = new byte[7 + 34 * sceWlan.channels.length];
            int responseOffset = 0;
            scanResponse[responseOffset] = 2;
            System.arraycopy(Wlan.getMacAddress(), 0, scanResponse, ++responseOffset, 6);
            responseOffset += 6;
            for (int channel : sceWlan.channels) {
                scanResponse[responseOffset] = (byte)channel;
                scanResponse[++responseOffset] = (byte)Modules.sceWlanModule.getChannelMode(channel);
                Utilities.writeStringNZ(scanResponse, ++responseOffset, 32, Modules.sceWlanModule.getChannelSSID(channel));
                responseOffset += 32;
            }
            this.sendPacket(scanResponse, 0, responseOffset);
        } else if (cmd == 2) {
            while (length >= 34) {
                String ssid;
                byte channel = buffer[offset];
                --length;
                byte mode = buffer[++offset];
                --length;
                if ((ssid = Utilities.readStringNZ(buffer, ++offset, 32)) != null && ssid.length() > 0 && channel != Modules.sceWlanModule.getJoinedChannel()) {
                    Modules.sceWlanModule.setChannelSSID(channel, ssid, mode);
                }
                offset += 32;
                length -= 32;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)String.format("processCmd unknown cmd=0x%X, buffer=%s", cmd, Utilities.getMemoryDump(buffer, offset, length)));
        }
    }

    @Override
    public int receiveWlanPacket(byte[] buffer, int offset, int length) throws IOException {
        int dataLength = -1;
        if (!this.createWlanSocket()) {
            return dataLength;
        }
        byte[] bytes = new byte[length + 1 + 32];
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        try {
            this.wlanSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("receiveWlanPacket message: %s", Utilities.getMemoryDump(packet.getData(), packet.getOffset(), packet.getLength())));
            }
            byte[] dataBytes = packet.getData();
            int dataOffset = packet.getOffset();
            dataLength = packet.getLength();
            if (dataLength < 33) {
                return -1;
            }
            byte cmd = dataBytes[dataOffset];
            ++dataOffset;
            --dataLength;
            if (cmd != 0) {
                this.processCmd(cmd, dataBytes, dataOffset, dataLength);
                return -1;
            }
            String ssid = Utilities.readStringNZ(dataBytes, dataOffset, 32);
            dataOffset += 32;
            dataLength -= 32;
            if (Modules.sceWlanModule.hasJoinedChannel() && !ssid.equals(Modules.sceWlanModule.getJoinedChannelSSID())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("receiveWlanPacket message SSID('%s') not matching the joined SSID('%s')", ssid, Modules.sceWlanModule.getJoinedChannelSSID()));
                }
                return -1;
            }
            System.arraycopy(dataBytes, dataOffset, buffer, offset, dataLength);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return dataLength;
    }

    @Override
    public void sendGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) throws IOException {
        byte[] bytes = new byte[macAddress.sizeof() + length];
        int bytesOffset = 0;
        System.arraycopy(macAddress.macAddress, 0, bytes, 0, macAddress.sizeof());
        System.arraycopy(buffer, offset, bytes, bytesOffset += macAddress.sizeof(), length);
        this.sendWlanPacket(bytes, 0, bytesOffset += length);
    }

    @Override
    public int receiveGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) throws IOException {
        int dataLength = -1;
        if (!this.createWlanSocket()) {
            return dataLength;
        }
        byte[] bytes = new byte[length + 1 + 32 + macAddress.sizeof()];
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        try {
            this.wlanSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("receiveGameModePacket message: %s", Utilities.getMemoryDump(packet.getData(), packet.getOffset(), packet.getLength())));
            }
            byte[] dataBytes = packet.getData();
            int dataOffset = packet.getOffset();
            dataLength = packet.getLength();
            byte cmd = dataBytes[dataOffset];
            ++dataOffset;
            --dataLength;
            if (cmd != 0) {
                this.processCmd(cmd, dataBytes, dataOffset, dataLength);
                return -1;
            }
            String ssid = Utilities.readStringNZ(dataBytes, dataOffset, 32);
            dataOffset += 32;
            dataLength -= 32;
            if (Modules.sceWlanModule.hasJoinedChannel() && !ssid.equals(Modules.sceWlanModule.getJoinedChannelSSID())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("receiveGameModePacket message SSID('%s') not matching the joined SSID('%s')", ssid, Modules.sceWlanModule.getJoinedChannelSSID()));
                }
                return -1;
            }
            macAddress.setMacAddress(dataBytes, dataOffset);
            System.arraycopy(dataBytes, dataOffset += macAddress.sizeof(), buffer, offset, dataLength -= macAddress.sizeof());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return dataLength;
    }

    @Override
    public void wlanScan(String ssid, int[] channels) throws IOException {
        byte[] scanRequestPacket = new byte[7];
        scanRequestPacket[0] = 1;
        System.arraycopy(Wlan.getMacAddress(), 0, scanRequestPacket, 1, 6);
        this.sendPacket(scanRequestPacket, 0, scanRequestPacket.length);
    }

    @Override
    public void sendAccessPointPacket(byte[] buffer, int offset, int length, EtherFrame etherFrame) throws IOException {
        InetSocketAddress[] broadcastAddress = sceNetInet.getBroadcastInetSocketAddress(JpcspWlanAdapter.getSocketPort());
        if (broadcastAddress != null) {
            for (int i = 0; i < broadcastAddress.length; ++i) {
                DatagramPacket packet = new DatagramPacket(buffer, offset, length, broadcastAddress[i]);
                try {
                    this.wlanSocket.send(packet);
                    continue;
                }
                catch (SocketException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"sendPacketFromAccessPoint", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendChatMessage(String message) {
        log.info((Object)String.format("Chat: %s", message));
    }
}

